/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.client;

import dev.compactmods.crafting.CompactCrafting;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="compactcrafting", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientConfig {
    public static ForgeConfigSpec CONFIG;
    private static ForgeConfigSpec.ConfigValue<String> PROJECTOR_COLOR;
    private static ForgeConfigSpec.ConfigValue<String> PROJECTOR_OFF_COLOR;
    private static ForgeConfigSpec.IntValue PLACEMENT_TIME;
    public static ForgeConfigSpec.BooleanValue ENABLE_DEBUG_ON_F3;
    public static int projectorColor;
    public static int projectorOffColor;
    public static int placementTime;

    public static boolean doDebugRender() {
        return Minecraft.m_91087_().f_91066_.f_92063_ && (Boolean)ENABLE_DEBUG_ON_F3.get() != false;
    }

    private static void generateConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("Projector Settings").push("projectors");
        PROJECTOR_COLOR = builder.comment(new String[]{"The color for the projector fields. (HEX format)", "Examples: Orange - #FF6A00, Violet - #32174D, Green - #00A658, Blue - #3A7FE1"}).define("projectorColor", (Object)"#FF6A00");
        PROJECTOR_OFF_COLOR = builder.comment("The color for the projectors when not active. (HEX format)").define("projectorOffColor", (Object)"#898989");
        ENABLE_DEBUG_ON_F3 = builder.comment("Whether or not activating F3 will enable debug renderers.").define("projectorDebugger", false);
        PLACEMENT_TIME = builder.comment("How long (ticks) the placement helper will show on right-clicking a projector.").defineInRange("placementTime", 160, 60, 240);
        builder.pop();
        CONFIG = builder.build();
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent configEvent) {
        projectorColor = ClientConfig.extractHexColor((String)PROJECTOR_COLOR.get(), 16738816);
        projectorOffColor = ClientConfig.extractHexColor((String)PROJECTOR_OFF_COLOR.get(), 0x898989);
        placementTime = (Integer)PLACEMENT_TIME.get();
    }

    private static int extractHexColor(String hex, int def) {
        try {
            if (hex.startsWith("#")) {
                return Integer.parseInt(hex.substring(1), 16);
            }
            return def;
        }
        catch (NumberFormatException nfe) {
            CompactCrafting.LOGGER.warn("Bad config value for projector color: {}", (Object)hex);
            return def;
        }
    }

    static {
        projectorColor = -1;
        projectorOffColor = -1;
        placementTime = 60;
        ClientConfig.generateConfig();
    }
}

